// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit
import MSSOrchestration

class ChangePasswordViewController: UIViewController {
    @IBOutlet weak var subtitleLabel: UILabel!
    @IBOutlet weak var promptUserIDLabel: UILabel!
    @IBOutlet weak var userIDLabel: UILabel!
    @IBOutlet weak var changePasswordButton: UIButton!
    
    private let orchestrationDelegate = OrchestrationSampleDelegate()
    private let serverCallHandler = ServerCallHandler()
    private let userAuthenticationDelegate = UserAuthenticationViewController()
    
    private var progressDialog: UIView?
    private var orchestrator: Orchestrator?

    override func viewDidLoad() {
        super.viewDidLoad()
        setupOrchestration()
        setupView()
    }
    
    // MARK: Setup
    private func setupOrchestration() {
        orchestrationDelegate.progressDialog = progressDialog
        orchestrationDelegate.viewController = self
        orchestrator = OrchestratorUtils.getOrchestrator(delegate: orchestrationDelegate)
        
        guard let orchestrator = orchestrator else {
            assertionFailure("the orchestrator object should have been set before")
            return
        }
                        
        serverCallHandler.viewController = self
        serverCallHandler.orchestrator = orchestrator
        
        // Used for custom password instead of default one
        userAuthenticationDelegate.useExternalPassword(orchestrator: orchestrator, viewController: self)
    }
    
    private func setupView() {
        userIDLabel.text = SharedPreferenceStorage.getActivatedUser()
        
        // Set localized strings
        title = "title_activity_change_password".localized
        subtitleLabel.text = "change_password_subtitle".localized
        changePasswordButton.setTitle("btn_change_password".localized, for: .normal)
        promptUserIDLabel.text = "prompt_user_id".localized + ":"
    }
    
    // MARK: IBActions
    @IBAction func onChangePasswordButtonClick(_ sender: Any) {
        guard let identifier = SharedPreferenceStorage.getActivatedUser() else {
            assertionFailure("orchestrationUser identifier is nil")
            return
        }
        let user = OrchestrationUser(identifier: identifier, domain: nil)
        let passwordParams = ChangePasswordParameters(user: user, cryptoAppIndex: .app2, delegate: self)
        orchestrator?.startChangePassword(with: passwordParams)
    }

    // MARK: Helpers
    private func sendCommandToServer(_ command: String) {
        serverCallHandler.progressDialog = progressDialog
        serverCallHandler.sendCommandToServer(command)
    }
}

extension ChangePasswordViewController: ChangePasswordDelegate {
    func orchestratorDidFinishChangePasswordWithSuccess(_ orchestrator: Orchestrator) {
        UIUtils.hideProgress(progressDialog)
        UIUtils.displayAlert(controller: self,
                             title: "dialog_title_change_password".localized,
                             message: "dialog_content_change_password_success".localized)
    }
    
    func orchestratorDidAbortChangePassword(_ orchestrator: Orchestrator) {
        UIUtils.hideProgress(progressDialog)
        UIUtils.displayAlert(controller: self,
                             title: "dialog_title_change_password".localized,
                             message: "dialog_content_change_password_abortion".localized)
    }
    
    func orchestrator(_ orchestrator: Orchestrator, didReceiveChangePasswordError error: OrchestrationError) {
        UIUtils.hideProgress(progressDialog)
        UIUtils.displayAlert(for: error, on: self)
    }
    
    func orchestrator(_ orchestrator: Orchestrator, didCompleteChangePasswordStepWith command: String) {
        progressDialog = UIUtils.displayProgress(controller: self, message: "dialog_progress_change_password".localized)
        orchestrationDelegate.progressDialog = progressDialog
        sendCommandToServer(command)
    }
}
